% Very simple example of a four channel scope with Burst Sine excitation
% hit "Control c" to exit
% Rev 6-18-97
clear all;

BLOCKSIZE = 512
OLDCHANNELS = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16]  %  make this 1 thru number of hardware channels that exist
CHANNELS  = [1 2 3 4]            %  list of active channels
SOURCE_CHS = [4097]
SPAN = 20000.
RANGE = 10.0
RANGE_S = 2.0
FREQ_HZ = 10000.
RAMP_TIME = .0005
DUTY_CYCLE = .5
GLOBAL_CHS = [1 2 3 4 4097]
DELAY = 0

Xtime = 1/(SPAN*2.56):1/(SPAN*2.56):BLOCKSIZE/(SPAN*2.56);  % time axis values
Xfreq = SPAN/(BLOCKSIZE/2.56):SPAN/(BLOCKSIZE/2.56):SPAN;   % Freq axis values

[status,session] = hpe1432('init','VXI0::8::INSTR',1,1);

[status] = hpe1432('deleteAllChanGroups',session);

   %create a group of all physical channels and then turn them off in case some previous
   %activity left them on
[status,gid] = hpe1432('createChannelGroup',session,length(OLDCHANNELS),OLDCHANNELS);

[status] = hpe1432('setActive',session,gid,'CHANNEL_OFF');

   %start fresh and create a group of just the channels that will be active
[status] = hpe1432('deleteAllChanGroups',session);
[status,gid] = hpe1432('createChannelGroup',session,length(CHANNELS),CHANNELS);
   %Create a group of just the sources that will be active
[status,gid_s] = hpe1432('createChannelGroup',session,length(SOURCE_CHS),SOURCE_CHS);
   %Create a global group of inputs and sources
[status,gid_global] = hpe1432('createChannelGroup',session,length(GLOBAL_CHS),GLOBAL_CHS);
   %Setup inputs
[status] = hpe1432('setActive',session,gid,'CHANNEL_ON');
[status] = hpe1432('setBlocksize',session,gid,BLOCKSIZE);
[status] = hpe1432('setRange',session,gid,RANGE);
[status] = hpe1432('setSpan',session,gid,SPAN);
[status] = hpe1432('setDataMode',session,gid,'BLOCK_MODE');
[status] = hpe1432('setTriggerDelay',session,gid,DELAY);  
%[status] = hpe1432('setAutoTrigger',session,gid,'MANUAL_TRIGGER');

%Setup source for Burst Sine

[status] = hpe1432('setActive',session,gid_s,'CHANNEL_ON');
[status] = hpe1432('setSourceMode',session,gid_s,'SOURCE_MODE_BSINE');

[status] = hpe1432('setSineFreq',session,gid_s,FREQ_HZ);
[status] = hpe1432('setRampRate',session,gid_s,RAMP_TIME);
[status] = hpe1432('setDutyCycle',session,gid_s,DUTY_CYCLE);
[status] = hpe1432('setRange',session,gid_s,RANGE_S);
[status] = hpe1432('setAutoTrigger',session,gid_s,'MANUAL_TRIGGER');
[status] = hpe1432('setTriggerChannel',session,gid_s,'CHANNEL_ON');

% Start measurement

[status] = hpe1432('initMeasure',session,gid_global)

A=1;
hold off;
while A>0,
 
[status,data,count] = hpe1432('readFloat64Data',session,gid,'TIME_DATA',BLOCKSIZE*length(CHANNELS),'WAIT_FLAG');

data_mat = reshape(data,BLOCKSIZE,length(CHANNELS)); 
subplot(4,1,1), plot(Xtime,data_mat(:,1)),drawnow;   % plot time data for channel 1
subplot(4,1,2), plot(Xtime,data_mat(:,2)),drawnow;   % plot time data for channel 2
data_fft = fft(data_mat);            %  fft the four channels
data_fft = (data_fft).*conj(data_fft);   % get magnitude 
data_fft= data_fft(1:BLOCKSIZE/2.56,:);   % alias free frequency range
subplot(4,1,3), semilogy (Xfreq,data_fft(:,1)),drawnow;  % plot frequency data channel 1
subplot(4,1,4), semilogy (Xfreq,data_fft(:,2)),drawnow;
A=A+1    % let user know the loop is working
end

[status] = hpe1432('close',session);
